<?php
/**
 * Mu Roulette
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');

echo '<div class="page-title"><span>'.lang('roulette_title_spin').'</span></div>';

try {
	
	// check ticket id
	if(!check_value($_GET['ticket'])) throw new Exception(lang('roulette_error_14'));
	
	// init roulette
	$MuRoulette = new \Plugin\MuRoulette\MuRoulette();
	$MuRoulette->setUsername($_SESSION['username']);
	$MuRoulette->setTicketId($_GET['ticket']);
	
	// check account characters
	$accountCharacters = $MuRoulette->getAccountCharacterList();
	
	// load ticket info
	$ticketInfo = $MuRoulette->getTicketInfo();
	
	// set character
	$MuRoulette->setCharacter($ticketInfo['character']);
	
	// use ticket
	$MuRoulette->useTicket();
	
	// token
	$rouletteApiToken = $MuRoulette->generateToken();
	
?>
	<div id="MuRouletteMedia" style="display:none;"><?php echo __PATH_TEMPLATE_IMG__; ?>roulette/</div>
	<div id="MuRouletteTicketId" style="display:none;"><?php echo $ticketInfo['id']; ?></div>
	<div id="MuRouletteToken" style="display:none;"><?php echo $rouletteApiToken; ?></div>
	<div class="wheelContainer">
		<div class="roulette-title">
			<img src="<?php echo __PATH_TEMPLATE_IMG__; ?>roulette/roulette-title.png" />
		</div>
		<svg class="wheelSVG" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="xMidYMid meet" text-rendering="optimizeSpeed">
			<defs>
				<filter id="shadow" x="-100%" y="-100%" width="550%" height="550%">
					<feOffset in="SourceAlpha" dx="0" dy="0" result="offsetOut"></feOffset>
					<feGaussianBlur stdDeviation="9" in="offsetOut" result="drop" />
					<feColorMatrix in="drop" result="color-out" type="matrix"
						values="0 0 0 0   0
						0 0 0 0   0 
						0 0 0 0   0 
						0 0 0 .3 0"/>
					<feBlend in="SourceGraphic" in2="color-out" mode="normal" />
				</filter>
			</defs>
			<g class="mainContainer">
				<g class="wheel"/>
			</g>
			<g class="centerCircle" />
			<g class="wheelOutline" />
			<g class="pegContainer" >
				<path  class="peg" fill="#EEEEEE" d="M22.139,0C5.623,0-1.523,15.572,0.269,27.037c3.392,21.707,21.87,42.232,21.87,42.232	s18.478-20.525,21.87-42.232C45.801,15.572,38.623,0,22.139,0z" />
			</g>
			<g class="valueContainer" />
		</svg>
		<div class="toast">
			<p></p>
		</div>
		<div class="roulette-info">
			<p class="rainbow"><?php echo lang('roulette_txt_15'); ?></p><br />
			<p class="rainbow"><?php echo lang('roulette_txt_16'); ?></p>
		</div>
	</div>

<?php
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}
?>